@extends('layouts.master')

@section('content')
    <div>
        <div class="card shadow">
            <div class="card-header  text-Dark">
                <h3 class="mb-0">Stock At Hand Report</h3>
            </div>
            <div class="card-body">
                <!-- Stock Report Form -->
                <form action="{{ route('stock_report.generate') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="supplier-select">Supplier</label>
                                <select id="supplier-select" class="form-control select2">
                                    <option value="">-- Select Supplier --</option>
                                    @foreach ($suppliers as $supplier)
                                        <option value="{{ $supplier->id_supplier }}">{{ $supplier->supplier_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="truck-select">Truck</label>
                                <select id="truck-select" class="form-control select2" disabled>
                                    <option value="">-- Select Truck --</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="main-category-select">Main Category</label>
                                <select id="main-category-select" class="form-control select2" disabled>
                                    <option value="">-- Select Main Category --</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="parent-category-select">Parent Category</label>
                                <select id="parent-category-select" class="form-control select2" disabled>
                                    <option value="">-- Select Parent Category --</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="child-category-select">Child Category</label>
                                <select id="child-category-select" class="form-control select2" disabled>
                                    <option value="">-- Select Child Category --</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="row mt-3">
                    <div class="col-md-12 text-right">
                        <button id="generate-report-btn" class="btn btn-primary">Generate Stock Report</button>

                    </div>
                </div>
                <div id="stock-report-section" class="mt-5 d-none">
                    <h4>Stock Report</h4>
                    <table id="stock-report-table" class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Main Category</th>
                                <th>Parent Category</th>
                                <th>Child Category</th>
                                <th>Stock (Bori)</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>

                {{-- <div class="row">
                    <div class="col-md-12 text-right">
                        <button id="generate-report-btn" class="btn btn-primary">Generate Stock Report</button>
                    </div>
                </div>
                <!-- Stock Report Table -->
                <div id="stock-report-section" class="mt-5 d-none">
                    <h4>Stock Report</h4>
                    <table id="stock-report-table" class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Truck No</th>
                                <th>Main Category</th>
                                <th>Parent Category</th>
                                <th>Child Category</th>
                                <th>Stock (Bori)</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div> --}}


                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Group By:</h5>
                        <div class="row">
                            <div class="col-6 ">
                                <div class="form-check form-check-inline">
                                    <input type="radio" class="form-check-input" name="group_by" value="client">
                                    <label class="form-check-label">Client</label>
                                </div>
                            </div>
                            <div class="col-6 ">
                                <div class="form-check form-check-inline">
                                    <input type="radio" class="form-check-input" name="group_by" value="product">
                                    <label class="form-check-label">Product</label>
                                </div>
                            </div>
                            <div class="col-6 ">
                                <div class="form-check form-check-inline">
                                    <input type="radio" class="form-check-input" name="group_by" value="vehicle_no">
                                    <label class="form-check-label">Vehicle No</label>
                                </div>
                            </div>
                            <div class="col-6 ">
                                <div class="form-check form-check-inline">
                                    <input type="radio" class="form-check-input" name="group_by" value="category">
                                    <label class="form-check-label">Category</label>
                                </div>
                            </div>
                            <div class="col-6 ">
                                <div class="form-check form-check-inline">
                                    <input type="radio" class="form-check-input" name="group_by" value="none">
                                    <label class="form-check-label">None</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <br>

                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">View:</h5>
                        <div class="row">
                            <div class="col-6 ">
                                <div class="form-check form-check-inline">
                                    <input type="radio" class="form-check-input" name="view" value="balance">
                                    <label class="form-check-label">Balance</label>
                                </div>
                            </div>
                            <div class="col-6 ">
                                <div class="form-check form-check-inline">
                                    <input type="radio" class="form-check-input" name="view" value="negative">
                                    <label class="form-check-label">Negative</label>
                                </div>
                            </div>
                            <div class="col-6 ">
                                <div class="form-check form-check-inline">
                                    <input type="radio" class="form-check-input" name="view" value="complete_sold">
                                    <label class="form-check-label">Complete Sold</label>
                                </div>
                            </div>
                            <div class="col-6 ">
                                <div class="form-check form-check-inline">
                                    <input type="radio" class="form-check-input" name="view" value="all">
                                    <label class="form-check-label">All</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <br>
                <div class="form-check mb-3">
                    <input type="checkbox" class="form-check-input" id="show_summary_only" name="show_summary_only">
                    <label class="form-check-label" for="show_summary_only">Show Summary Only</label>
                </div>

                <div class="d-flex justify-content-between">
                    <button type="submit" class="btn btn-primary">OK</button>
                    <button type="reset" class="btn btn-secondary">Cancel</button>
                </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        // $(document).ready(function() {
        //     $('#truck-select').change(function() {
        //         const truckId = $(this).val();
        //         if (truckId) {
        //             $.ajax({
        //                 url: "{{ route('get.main.categories') }}",
        //                 method: 'POST',
        //                 data: {
        //                     truck_id: truckId,
        //                     _token: '{{ csrf_token() }}'
        //                 },
        //                 success: function(data) {
        //                     $('#main-category-select').html(
        //                         '<option value="">-- Select Main Category --</option>');
        //                     $.each(data, function(index, category) {
        //                         $('#main-category-select').append(
        //                             `<option value="${category.id_pro_cate_main}">${category.products_category_name}</option>`
        //                         );
        //                     });
        //                     $('#main-category-select').prop('disabled', false);
        //                 }
        //             });
        //         }
        //     });

        //     $('#main-category-select').change(function() {
        //         const mainCategoryId = $(this).val();
        //         const truckId = $('#truck-select').val();
        //         if (mainCategoryId) {
        //             $.ajax({
        //                 url: "{{ route('get.parent.categories') }}",
        //                 method: 'POST',
        //                 data: {
        //                     main_category_id: mainCategoryId,
        //                     truck_id: truckId,
        //                     _token: '{{ csrf_token() }}'
        //                 },
        //                 success: function(data) {
        //                     $('#parent-category-select').html(
        //                         '<option value="">-- Select Parent Category --</option>');
        //                     $.each(data, function(index, category) {
        //                         $('#parent-category-select').append(
        //                             `<option value="${category.id_pro_sub_cat_parent}">${category.name}</option>`
        //                         );
        //                     });
        //                     $('#parent-category-select').prop('disabled', false);
        //                 }
        //             });
        //         }
        //     });

        //     $('#parent-category-select').change(function() {
        //         const parentCategoryId = $(this).val();
        //         const truckId = $('#truck-select').val();
        //         if (parentCategoryId) {
        //             $.ajax({
        //                 url: "{{ route('get.child.categories') }}",
        //                 method: 'POST',
        //                 data: {
        //                     parent_category_id: parentCategoryId,
        //                     truck_id: truckId,
        //                     _token: '{{ csrf_token() }}'
        //                 },
        //                 success: function(data) {
        //                     $('#child-category-select').html(
        //                         '<option value="">-- Select Child Category --</option>');
        //                     $.each(data, function(index, category) {
        //                         $('#child-category-select').append(
        //                             `<option value="${category.id_pro_sub_cat_child}">${category.name}</option>`
        //                         );
        //                     });
        //                     $('#child-category-select').prop('disabled', false);
        //                 }
        //             });
        //         }
        //     });
        // });

        // $(document).ready(function() {
        //     $('#supplier-select').change(function() {
        //         const supplierId = $(this).val();
        //         if (supplierId) {
        //             $.ajax({
        //                 url: "{{ route('get.main.categories') }}",
        //                 method: 'POST',
        //                 data: {
        //                     supplier_id: supplierId,
        //                     _token: '{{ csrf_token() }}'
        //                 },
        //                 success: function(data) {
        //                     $('#main-category-select').html(
        //                         '<option value="">-- Select Main Category --</option>');
        //                     $.each(data, function(index, category) {
        //                         $('#main-category-select').append(
        //                             `<option value="${category.id_pro_cate_main}">${category.products_category_name}</option>`
        //                         );
        //                     });
        //                     $('#main-category-select').prop('disabled', false);
        //                 }
        //             });
        //         }
        //     });

        //     $('#main-category-select').change(function() {
        //         const mainCategoryId = $(this).val();
        //         const supplierId = $('#supplier-select').val();
        //         if (mainCategoryId) {
        //             $.ajax({
        //                 url: "{{ route('get.parent.categories') }}",
        //                 method: 'POST',
        //                 data: {
        //                     main_category_id: mainCategoryId,
        //                     supplier_id: supplierId,
        //                     _token: '{{ csrf_token() }}'
        //                 },
        //                 success: function(data) {
        //                     $('#parent-category-select').html(
        //                         '<option value="">-- Select Parent Category --</option>');
        //                     $.each(data, function(index, category) {
        //                         $('#parent-category-select').append(
        //                             `<option value="${category.id_pro_sub_cat_parent}">${category.name}</option>`
        //                         );
        //                     });
        //                     $('#parent-category-select').prop('disabled', false);
        //                 }
        //             });
        //         }
        //     });

        //     $('#parent-category-select').change(function() {
        //         const parentCategoryId = $(this).val();
        //         const supplierId = $('#supplier-select').val();
        //         if (parentCategoryId) {
        //             $.ajax({
        //                 url: "{{ route('get.child.categories') }}",
        //                 method: 'POST',
        //                 data: {
        //                     parent_category_id: parentCategoryId,
        //                     supplier_id: supplierId,
        //                     _token: '{{ csrf_token() }}'
        //                 },
        //                 success: function(data) {
        //                     $('#child-category-select').html(
        //                         '<option value="">-- Select Child Category --</option>');
        //                     $.each(data, function(index, category) {
        //                         $('#child-category-select').append(
        //                             `<option value="${category.id_pro_sub_cat_child}">${category.name}</option>`
        //                         );
        //                     });
        //                     $('#child-category-select').prop('disabled', false);
        //                 }
        //             });
        //         }
        //     });
        // });



        // $(document).ready(function() {
        //     // Initialize Select2 and Datepicker
        //     $('#truck-select').select2({
        //         theme: 'default'
        //     });
        //     $('#main-category-select').select2({
        //         theme: 'default'
        //     });
        //     $('#parent-category-select').select2({
        //         theme: 'default'
        //     });
        //     $('#child-category-select').select2({
        //         theme: 'default'
        //     });
        // });

        // $(document).ready(function() {
        //     $('#generate-report-btn').on('click', function(e) {
        //         e.preventDefault();

        //         // Collect selected values
        //         const truckId = $('#truck-select').val();
        //         const mainCategoryId = $('#main-category-select').val();
        //         const parentCategoryId = $('#parent-category-select').val();
        //         const childCategoryId = $('#child-category-select').val();

        //         // Debugging: Log the selected values
        //         console.log('Truck ID:', truckId);
        //         console.log('Main Category ID:', mainCategoryId);
        //         console.log('Parent Category ID:', parentCategoryId);
        //         console.log('Child Category ID:', childCategoryId);

        //         // Validate input
        //         if (!truckId) {
        //             alert('Please select a Truck!');
        //             return;
        //         }
        //         if (!mainCategoryId) {
        //             alert('Please select a Main Category!');
        //             return;
        //         }
        //         if (!parentCategoryId) {
        //             alert('Please select a Parent Category!');
        //             return;
        //         }
        //         if (!childCategoryId) {
        //             alert('Please select a Child Category!');
        //             return;
        //         }

        //         // Clear previous results
        //         const tbody = $('#stock-report-table tbody');
        //         tbody.empty();
        //         $('#stock-report-section').addClass('d-none');

        //         // Fetch stock report data
        //         $.ajax({
        //             url: '{{ route('stock_report.generate') }}',
        //             method: 'POST',
        //             data: {
        //                 _token: '{{ csrf_token() }}',
        //                 truck_no: truckId,
        //                 main_category: mainCategoryId,
        //                 parent_category: parentCategoryId,
        //                 child_category: childCategoryId
        //             },
        //             success: function(response) {
        //                 // Check if response contains stock data
        //                 if (response.stockData && response.stockData.length > 0) {
        //                     response.stockData.forEach(function(data) {
        //                         tbody.append(`
    //                     <tr>
    //                         <td>${data.truck_no || 'N/A'}</td>
    //                         <td>${data.main_category || 'N/A'}</td>
    //                         <td>${data.parent_category || 'N/A'}</td>
    //                         <td>${data.child_category || 'N/A'}</td>
    //                         <td>${data.bori || 0}</td>
    //                     </tr>
    //                 `);
        //                     });

        //                     // Show the table section
        //                     $('#stock-report-section').removeClass('d-none');
        //                 } else {
        //                     alert('No stock data found for the selected criteria.');
        //                 }
        //             },
        //             error: function(xhr, status, error) {
        //                 console.error('AJAX Error:', error);
        //                 console.error('Response:', xhr.responseText);
        //                 alert(
        //                     'Failed to fetch stock data. Please check the console for details.');
        //             }
        //         });
        //     });
        // });

        // $(document).ready(function() {
        //     $('#generate-report-btn').on('click', function(e) {
        //         e.preventDefault();

        //         // Collect selected category values
        //         const mainCategoryId = $('#main-category-select').val();
        //         const parentCategoryId = $('#parent-category-select').val();
        //         const childCategoryId = $('#child-category-select').val();

        //         // Validate if categories are selected
        //         if (!mainCategoryId || !parentCategoryId || !childCategoryId) {
        //             alert('Please select all required fields!');
        //             return;
        //         }

        //         // Clear previous results
        //         const tbody = $('#stock-report-table tbody');
        //         tbody.empty();
        //         $('#stock-report-section').addClass('d-none');

        //         // Fetch stock report data
        //         $.ajax({
        //             url: '{{ route('stock_report.generate') }}',
        //             method: 'POST',
        //             data: {
        //                 _token: '{{ csrf_token() }}',
        //                 main_category: mainCategoryId,
        //                 parent_category: parentCategoryId,
        //                 child_category: childCategoryId
        //             },
        //             success: function(response) {
        //                 // Populate the table
        //                 const tbody = $('#stock-report-table tbody');
        //                 tbody.empty();

        //                 if (response.stockData && response.stockData.length > 0) {
        //                     response.stockData.forEach(function(data) {
        //                         tbody.append(`
    //         <tr>
    //             <td>${data.truck_no}</td>
    //             <td>${data.main_category_name}</td>
    //             <td>${data.parent_category_name}</td>
    //             <td>${data.child_category_name}</td>
    //             <td>${data.bori}</td>
    //         </tr>
    //     `);
        //                     });

        //                     // Show the table section
        //                     $('#stock-report-section').removeClass('d-none');
        //                 } else {
        //                     alert('No stock data found for the selected criteria.');
        //                 }
        //             },

        //             error: function(xhr, status, error) {
        //                 console.error('AJAX Error:', error);
        //                 console.error('Response:', xhr.responseText);
        //                 alert(
        //                     'Failed to fetch stock data. Please check the console for details.'
        //                 );
        //             }
        //         });
        //     });
        // });

        $(document).ready(function() {
            // Supplier Selection
            $('#supplier-select').change(function() {
                const supplierId = $(this).val();
                if (supplierId) {
                    $.ajax({
                        url: "{{ route('get.trucks') }}",
                        method: 'POST',
                        data: {
                            supplier_id: supplierId,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {
                            $('#truck-select').html(
                                '<option value="">-- Select Truck --</option>');
                            $.each(data, function(index, truck) {
                                $('#truck-select').append(
                                    `<option value="${truck.id_truck}">${truck.truck_no}</option>`
                                );
                            });
                            $('#truck-select').prop('disabled', false);
                        }
                    });
                }
            });

            // Truck Selection
            $('#truck-select').change(function() {
                const truckId = $(this).val();
                const supplierId = $('#supplier-select').val();
                if (truckId) {
                    $.ajax({
                        url: "{{ route('get.main.categories') }}",
                        method: 'POST',
                        data: {
                            supplier_id: supplierId,
                            truck_id: truckId,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {
                            $('#main-category-select').html(
                                '<option value="">-- Select Main Category --</option>');
                            $.each(data, function(index, category) {
                                $('#main-category-select').append(
                                    `<option value="${category.id_pro_cate_main}">${category.products_category_name}</option>`
                                );
                            });
                            $('#main-category-select').prop('disabled', false);
                        }
                    });
                }
            });

            // Main Category Selection
            $('#main-category-select').change(function() {
                const mainCategoryId = $(this).val();
                const supplierId = $('#supplier-select').val();
                if (mainCategoryId) {
                    $.ajax({
                        url: "{{ route('get.parent.categories') }}",
                        method: 'POST',
                        data: {
                            main_category_id: mainCategoryId,
                            supplier_id: supplierId,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {
                            $('#parent-category-select').html(
                                '<option value="">-- Select Parent Category --</option>');
                            $.each(data, function(index, category) {
                                $('#parent-category-select').append(
                                    `<option value="${category.id_pro_sub_cat_parent}">${category.name}</option>`
                                );
                            });
                            $('#parent-category-select').prop('disabled', false);
                        }
                    });
                }
            });

            // Parent Category Selection
            $('#parent-category-select').change(function() {
                const parentCategoryId = $(this).val();
                const supplierId = $('#supplier-select').val();
                if (parentCategoryId) {
                    $.ajax({
                        url: "{{ route('get.child.categories') }}",
                        method: 'POST',
                        data: {
                            parent_category_id: parentCategoryId,
                            supplier_id: supplierId,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {
                            $('#child-category-select').html(
                                '<option value="">-- Select Child Category --</option>');
                            $.each(data, function(index, category) {
                                $('#child-category-select').append(
                                    `<option value="${category.id_pro_sub_cat_child}">${category.name}</option>`
                                );
                            });
                            $('#child-category-select').prop('disabled', false);
                        }
                    });
                }
            });

            // Initialize Select2
            $('#supplier-select, #truck-select, #main-category-select, #parent-category-select, #child-category-select')
                .select2({
                    theme: 'default'
                });

            // Generate Report Button
            $('#generate-report-btn').on('click', function(e) {
                e.preventDefault();

                // Validate selected values
                const mainCategoryId = $('#main-category-select').val();
                const parentCategoryId = $('#parent-category-select').val();
                const childCategoryId = $('#child-category-select').val();

                if (!mainCategoryId || !parentCategoryId || !childCategoryId) {
                    alert('Please select all required fields!');
                    return;
                }

                // Clear previous results and fetch new data
                const tbody = $('#stock-report-table tbody');
                tbody.empty();
                $('#stock-report-section').addClass('d-none');

                $.ajax({
                    url: '{{ route('stock_report.generate') }}',
                    method: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        main_category: mainCategoryId,
                        parent_category: parentCategoryId,
                        child_category: childCategoryId
                    },
                    success: function(response) {
                        if (response.stockData && response.stockData.length > 0) {
                            response.stockData.forEach(function(data) {
                                tbody.append(`
                                <tr>
                                    <td>${data.main_category_name}</td>
                                    <td>${data.parent_category_name}</td>
                                    <td>${data.child_category_name}</td>
                                    <td>${data.bori}</td>
                                    </tr>
                                    `);
                                // <td>${data.truck_no}</td>
                            });
                            $('#stock-report-section').removeClass('d-none');
                        } else {
                            alert('No stock data found for the selected criteria.');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', error);
                        console.error('Response:', xhr.responseText);
                        alert(
                            'Failed to fetch stock data. Please check the console for details.'
                        );
                    }
                });
            });
        });
    </script>
@endpush
